//                      GILBERT AND THE DOORS V2.2.3
//           https://sites.google.com/view/gilbert-and-the-doors
//               COPYRIGHT (c) Daniel Champagne 2016-2018
//                 Contact EMAIL: phoenixbozo@gmail.com
/*
  Gilbert and the doors is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

DEPENDENCY
----------
0-STANDARD Libc (With GCC)
1-LIBSDL1.2
2-LIBSDL_mixer1.2
3-MATH

libsdl1.2
---------
sudo apt-get update
sudo apt-get install libsdl1.2-dev libsdl-mixer1.2-dev

Compile with command line on linux terminal:
gcc -o Gilbert Gilbert.c Widjet.c MoteurDeJeu.c -lm -lSDL_mixer  `sdl-config --libs --cflags`

Compile with (GEANY) on linux:
 gcc -Wall -o  "%e" "%f" -no-pie Widjet.c MoteurDeJeu.c -lm -lSDL_mixer  -lSDL
*/
#include <stdlib.h>
#include <SDL/SDL.h>
#include <math.h>
#include "Widjet.h"
#include "MoteurDeJeu.h"

#define Largeur_Curseur 16
#define bordurebutton 2
#define bordureedit 2
#define offsetbordureedit 1
#define Offset_Curseur ((Largeur_Curseur/2))
#define Largeur_TrackBar  Width
#define Position_Sur_La_Surface_A_Ecrire  wx
#define Key(Bz,Cz)  if (event->key[Cz]==1) {strcat(ChaineModif,Bz);event->key[Cz]=0;return 0;}


//fonction interne

Uint32 getpixel(SDL_Surface *surface, int x, int y);
void putpixel(SDL_Surface *surface, int x, int y, Uint32 pixel);

// fin fonction intern

// fonction d'initialisation widjet
void WidjetInit(Widjet *Structure);
void WidjetFree(Widjet *Structure);
void WidjetGetFont(int Size,Uint32 Couleur,Uint32 CouleurFond,Widjet *Structure);
void WidjetGetPic(Widjet *Structure);
void UpdateEvents(Input* in);
// fonction d'initialisation widjet fin

// fonction universel
Uint32 WidjetRGB(Uint32 Red,Uint32 Green,Uint32 Blue);
Uint32 WidjetRed(Uint32 Color);
Uint32 WidjetGreen(Uint32 Color);
Uint32 WidjetBlue(Uint32 Color);
void WidjetZoomSurface(int Zoom,SDL_Surface **Surface);
void WidjetColorSurface(Uint32 Color,SDL_Surface **Surface);
void WidjetBlitAndStretch(SDL_Surface **INSurface,Uint32 ColorAlpha,int wx,int wy,int Width,int Height,SDL_Surface **Render);
void WidjetBlitLine(int wx1,int wy1,Uint32 Color,int wx2,int wy2,SDL_Surface **render);
Uint32 WidjetTimer(Uint32 Delayms,Uint32 *VariableDeComparaison);
Uint32 WidjetTimerTrigger(Uint32 Delayms,Uint32 *VariableDeComparaison);
// fonction universel fin

//widjet
void WidjetText(int x,int y,char *text,Widjet *Structure);
void WidjetNumericText(int x,int y,int Valeur,Widjet *Structure);
int WidjetRadioButton(int wx,int wy,char Text[255],Widjet *Structure);
int WidjetCheckBox(int wx,int wy,char Text[255],int *Checked,Widjet *Structure);
int WidjetTrackBar(int wx,int wy,int Width,int start,int end,int *TrackBarInOutValue,Widjet *Structure);
int WidjetButton(int wx,int wy,int Width,int Height,char Text[255],Widjet *Structure);
int WidjetButtonBMP(int wx,int wy,int Width,int Height,char Text[255],SDL_Surface **ImageMap,Widjet *Structure);
void WidjetProgressBar(int wx,int wy,int Width,int Height,int Min,int Max,int Value,Widjet *Structure);
int WidjetZoneToutch(int wx,int wy,int Width,int Height,Widjet *Structure);
int WidjetFlatPanel(int wx,int wy,int Width,int Height,Widjet *Structure);
//widjet fin

//////fin declaration prototype

void WidjetNumericText(int x,int y,int Valeur,Widjet *Structure){
char inttotext[255]="";
sprintf (inttotext, "%d",Valeur);
WidjetText(x,y,inttotext,Structure);
}

void WidjetGetFont(int Size,Uint32 Couleur,Uint32 CouleurFond,Widjet *Structure){
if (CouleurFond==DEFAULT) {CouleurFond=16777215;}
if (Couleur==DEFAULT) {Couleur=0;}
if (Size==DEFAULT) {Size=0;}
//police de caractere de 7 pixel par 9
int x,y,t;
int p[7][9];
for (t=0;t<70;t++) {SDL_FreeSurface(Structure->FontPic[t]);}
/// '00' 
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=1;p[3][3]=1;
p[4][3]=1;p[5][3]=1;p[6][3]=1;p[0][4]=1;p[1][4]=1;p[2][4]=1;
p[3][4]=1;p[4][4]=1;p[5][4]=1;p[6][4]=1;p[0][5]=1;p[1][5]=1;
p[2][5]=1;p[3][5]=1;p[4][5]=1;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=1;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=1;p[2][7]=1;p[3][7]=1;p[4][7]=1;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=1;p[2][8]=1;p[3][8]=1;p[4][8]=1;
p[5][8]=1;p[6][8]=1;
GetPic(0);

/// 'A'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=2;
p[4][0]=0;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=2;
p[3][1]=2;p[4][1]=2;p[5][1]=0;p[6][1]=1;p[0][2]=1;p[1][2]=2;
p[2][2]=2;p[3][2]=0;p[4][2]=2;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=2;p[2][5]=2;p[3][5]=2;p[4][5]=2;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=2;
p[2][8]=0;p[3][8]=1;p[4][8]=1;p[5][8]=2;p[6][8]=0;
GetPic(1);

/// 'B'
p[0][0]=1;
p[1][0]=2;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=0;p[6][0]=1;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=2;p[2][2]=0;p[3][2]=1;p[4][2]=1;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=2;
p[3][4]=2;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=2;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(2);

/// 'C'
p[0][0]=1;p[1][0]=1;p[2][0]=2;p[3][0]=2;
p[4][0]=2;p[5][0]=0;p[6][0]=1;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=1;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=1;p[4][5]=1;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(3);

///'D'
p[0][0]=1;
p[1][0]=2;p[2][0]=2;p[3][0]=2;p[4][0]=0;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=2;p[5][1]=0;
p[6][1]=1;p[0][2]=1;p[1][2]=2;p[2][2]=0;p[3][2]=1;p[4][2]=1;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=2;p[5][7]=0;
p[6][7]=1;p[0][8]=1;p[1][8]=2;p[2][8]=2;p[3][8]=2;p[4][8]=0;
p[5][8]=1;p[6][8]=1;
GetPic(4);

///'E'
p[0][0]=1;p[1][0]=2;p[2][0]=2;p[3][0]=2;
p[4][0]=2;p[5][0]=2;p[6][0]=0;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=2;p[2][4]=2;p[3][4]=2;p[4][4]=0;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=1;p[4][5]=1;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=2;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=2;p[6][8]=0;
GetPic(5);

///'F'
p[0][0]=1;
p[1][0]=2;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=2;p[6][0]=0;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=2;p[2][2]=0;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=1;p[6][3]=1;p[0][4]=1;p[1][4]=2;p[2][4]=2;
p[3][4]=2;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=2;p[2][8]=0;p[3][8]=1;p[4][8]=1;
p[5][8]=1;p[6][8]=1;
GetPic(6);

///'G'
p[0][0]=1;p[1][0]=1;p[2][0]=2;p[3][0]=2;
p[4][0]=2;p[5][0]=0;p[6][0]=1;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=2;p[4][4]=2;p[5][4]=0;
p[6][4]=1;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(7);

///'H'
p[0][0]=1;p[1][0]=2;p[2][0]=0;p[3][0]=1;
p[4][0]=1;p[5][0]=2;p[6][0]=0;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=2;p[2][4]=2;p[3][4]=2;p[4][4]=2;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=2;
p[2][8]=0;p[3][8]=1;p[4][8]=1;p[5][8]=2;p[6][8]=0;
GetPic(8);

///'I'
p[0][0]=1;
p[1][0]=1;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=0;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=2;p[4][1]=0;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=2;p[4][2]=0;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=1;p[3][3]=2;
p[4][3]=0;p[5][3]=1;p[6][3]=1;p[0][4]=1;p[1][4]=1;p[2][4]=1;
p[3][4]=2;p[4][4]=0;p[5][4]=1;p[6][4]=1;p[0][5]=1;p[1][5]=1;
p[2][5]=1;p[3][5]=2;p[4][5]=0;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=2;p[4][6]=0;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=1;p[2][7]=1;p[3][7]=2;p[4][7]=0;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(9);

///'J'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=2;
p[4][0]=2;p[5][0]=2;p[6][0]=0;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=1;p[4][1]=2;p[5][1]=0;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=1;p[3][2]=1;p[4][2]=2;p[5][2]=0;p[6][2]=1;p[0][3]=1;
p[1][3]=1;p[2][3]=1;p[3][3]=1;p[4][3]=2;p[5][3]=0;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=1;p[3][4]=1;p[4][4]=2;p[5][4]=0;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=1;p[4][5]=2;
p[5][5]=0;p[6][5]=1;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=2;p[5][6]=0;p[6][6]=1;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=2;p[5][7]=0;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=0;p[5][8]=1;p[6][8]=1;
GetPic(10);

///'K'
p[0][0]=1;p[1][0]=2;p[2][0]=0;p[3][0]=1;
p[4][0]=1;p[5][0]=2;p[6][0]=0;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=2;p[5][2]=0;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=2;p[4][3]=0;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=2;p[2][4]=2;p[3][4]=0;p[4][4]=1;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=2;p[4][5]=0;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=2;p[5][6]=0;p[6][6]=1;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=2;
p[2][8]=0;p[3][8]=1;p[4][8]=1;p[5][8]=2;p[6][8]=0;
GetPic(11);

///'L'
p[0][0]=1;
p[1][0]=2;p[2][0]=0;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=2;p[2][2]=0;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=1;p[6][3]=1;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=1;p[6][4]=1;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=2;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=2;p[6][8]=0;
GetPic(12);

///'M'
p[0][0]=1;p[1][0]=2;p[2][0]=0;p[3][0]=1;
p[4][0]=1;p[5][0]=2;p[6][0]=0;p[0][1]=1;p[1][1]=2;p[2][1]=2;
p[3][1]=0;p[4][1]=2;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=2;p[4][2]=0;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=2;
p[2][8]=0;p[3][8]=1;p[4][8]=1;p[5][8]=2;p[6][8]=0;
GetPic(13);

///'N'
p[0][0]=1;
p[1][0]=2;p[2][0]=0;p[3][0]=1;p[4][0]=1;p[5][0]=2;p[6][0]=0;
p[0][1]=1;p[1][1]=2;p[2][1]=2;p[3][1]=0;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=2;p[2][2]=2;p[3][2]=0;p[4][2]=1;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=2;
p[4][3]=0;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=2;p[4][4]=0;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=2;p[4][5]=0;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=2;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=2;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=2;p[2][8]=0;p[3][8]=1;p[4][8]=1;
p[5][8]=2;p[6][8]=0;
GetPic(14);

///'O'
p[0][0]=1;p[1][0]=1;p[2][0]=2;p[3][0]=2;
p[4][0]=2;p[5][0]=0;p[6][0]=1;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(15);

///'P'
p[0][0]=1;
p[1][0]=2;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=0;p[6][0]=1;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=2;p[2][2]=0;p[3][2]=1;p[4][2]=1;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=2;
p[3][4]=2;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=2;p[2][8]=0;p[3][8]=1;p[4][8]=1;
p[5][8]=1;p[6][8]=1;
GetPic(16);

///'Q'
p[0][0]=1;p[1][0]=1;p[2][0]=2;p[3][0]=2;
p[4][0]=2;p[5][0]=0;p[6][0]=1;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=2;p[4][5]=0;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=2;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=2;p[5][7]=0;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=0;p[5][8]=2;p[6][8]=0;
GetPic(17);

///'R'
p[0][0]=1;
p[1][0]=2;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=0;p[6][0]=1;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=2;p[2][2]=0;p[3][2]=1;p[4][2]=1;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=2;
p[3][4]=2;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=2;
p[2][5]=2;p[3][5]=0;p[4][5]=1;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=2;p[4][6]=0;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=2;p[5][7]=0;
p[6][7]=1;p[0][8]=1;p[1][8]=2;p[2][8]=0;p[3][8]=1;p[4][8]=1;
p[5][8]=2;p[6][8]=0;
GetPic(18);

///'S'
p[0][0]=1;p[1][0]=1;p[2][0]=2;p[3][0]=2;
p[4][0]=2;p[5][0]=0;p[6][0]=1;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=0;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=2;p[3][4]=2;p[4][4]=2;p[5][4]=0;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(19);

///'T'
p[0][0]=1;
p[1][0]=2;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=2;p[6][0]=0;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=2;p[4][1]=0;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=2;p[4][2]=0;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=1;p[3][3]=2;
p[4][3]=0;p[5][3]=1;p[6][3]=1;p[0][4]=1;p[1][4]=1;p[2][4]=1;
p[3][4]=2;p[4][4]=0;p[5][4]=1;p[6][4]=1;p[0][5]=1;p[1][5]=1;
p[2][5]=1;p[3][5]=2;p[4][5]=0;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=2;p[4][6]=0;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=1;p[2][7]=1;p[3][7]=2;p[4][7]=0;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=1;p[2][8]=1;p[3][8]=2;p[4][8]=0;
p[5][8]=1;p[6][8]=1;
GetPic(20);

///'U'
p[0][0]=1;p[1][0]=2;p[2][0]=0;p[3][0]=1;
p[4][0]=1;p[5][0]=2;p[6][0]=0;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(21);

///'V'
p[0][0]=1;
p[1][0]=2;p[2][0]=0;p[3][0]=1;p[4][0]=1;p[5][0]=2;p[6][0]=0;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=2;p[2][2]=0;p[3][2]=1;p[4][2]=1;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=1;p[2][6]=2;p[3][6]=0;p[4][6]=2;p[5][6]=0;p[6][6]=1;
p[0][7]=1;p[1][7]=1;p[2][7]=2;p[3][7]=0;p[4][7]=2;p[5][7]=0;
p[6][7]=1;p[0][8]=1;p[1][8]=1;p[2][8]=1;p[3][8]=2;p[4][8]=0;
p[5][8]=1;p[6][8]=1;
GetPic(22);

///'W'
p[0][0]=1;p[1][0]=2;p[2][0]=0;p[3][0]=1;
p[4][0]=1;p[5][0]=2;p[6][0]=0;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=2;
p[4][6]=0;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=2;
p[3][7]=0;p[4][7]=2;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=2;
p[2][8]=0;p[3][8]=1;p[4][8]=1;p[5][8]=2;p[6][8]=0;
GetPic(23);

///'X'
p[0][0]=1;
p[1][0]=2;p[2][0]=0;p[3][0]=1;p[4][0]=1;p[5][0]=2;p[6][0]=0;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=1;p[2][2]=2;p[3][2]=0;p[4][2]=2;
p[5][2]=0;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=2;p[3][3]=0;
p[4][3]=2;p[5][3]=0;p[6][3]=1;p[0][4]=1;p[1][4]=1;p[2][4]=1;
p[3][4]=2;p[4][4]=0;p[5][4]=1;p[6][4]=1;p[0][5]=1;p[1][5]=1;
p[2][5]=2;p[3][5]=0;p[4][5]=2;p[5][5]=0;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=2;p[3][6]=0;p[4][6]=2;p[5][6]=0;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=2;p[2][8]=0;p[3][8]=1;p[4][8]=1;
p[5][8]=2;p[6][8]=0;
GetPic(24);

///'Y'
p[0][0]=1;p[1][0]=2;p[2][0]=0;p[3][0]=1;
p[4][0]=1;p[5][0]=2;p[6][0]=0;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=1;p[2][3]=2;p[3][3]=0;p[4][3]=2;p[5][3]=0;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=2;p[3][4]=0;p[4][4]=2;p[5][4]=0;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=2;p[4][5]=0;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=2;
p[4][6]=0;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=1;p[2][7]=1;
p[3][7]=2;p[4][7]=0;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=1;p[3][8]=2;p[4][8]=0;p[5][8]=1;p[6][8]=1;
GetPic(25);

///'Z'
p[0][0]=1;
p[1][0]=2;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=2;p[6][0]=0;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=2;
p[5][2]=0;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=1;p[3][3]=1;
p[4][3]=2;p[5][3]=0;p[6][3]=1;p[0][4]=1;p[1][4]=1;p[2][4]=1;
p[3][4]=2;p[4][4]=0;p[5][4]=1;p[6][4]=1;p[0][5]=1;p[1][5]=1;
p[2][5]=2;p[3][5]=0;p[4][5]=1;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=2;p[3][6]=1;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=2;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=2;p[6][8]=0;
GetPic(26);

///'0'
p[0][0]=1;p[1][0]=1;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=0;p[6][0]=1;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=2;p[2][2]=0;p[3][2]=1;p[4][2]=1;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(27);

///'1'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=2;
p[4][0]=0;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=2;
p[3][1]=2;p[4][1]=0;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=1;p[3][2]=2;p[4][2]=0;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=1;p[2][3]=1;p[3][3]=2;p[4][3]=0;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=1;p[3][4]=2;p[4][4]=0;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=2;p[4][5]=0;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=2;
p[4][6]=0;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=1;p[2][7]=1;
p[3][7]=2;p[4][7]=0;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(28);

///'2'
p[0][0]=1;
p[1][0]=1;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=0;p[6][0]=1;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=1;p[2][3]=1;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=1;p[2][4]=1;
p[3][4]=1;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=1;
p[2][5]=1;p[3][5]=2;p[4][5]=0;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=2;p[3][6]=0;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=2;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=2;p[6][8]=0;
GetPic(29);

///'3'
p[0][0]=1;p[1][0]=1;p[2][0]=2;p[3][0]=2;
p[4][0]=2;p[5][0]=0;p[6][0]=1;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=1;
p[2][2]=1;p[3][2]=1;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=1;p[2][3]=1;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=1;p[2][4]=1;p[3][4]=2;p[4][4]=2;p[5][4]=0;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(30);

///'4'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=2;p[6][0]=0;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=2;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=2;p[4][2]=0;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=1;p[2][3]=2;p[3][3]=0;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=2;p[1][5]=2;
p[2][5]=2;p[3][5]=2;p[4][5]=2;p[5][5]=2;p[6][5]=2;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=1;p[2][7]=1;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=1;p[3][8]=1;p[4][8]=1;
p[5][8]=2;p[6][8]=0;
GetPic(31);

///'5'
p[0][0]=1;p[1][0]=2;p[2][0]=2;p[3][0]=2;
p[4][0]=2;p[5][0]=2;p[6][0]=0;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=2;p[2][4]=2;p[3][4]=2;p[4][4]=2;p[5][4]=0;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(32);

///'6'
p[0][0]=1;
p[1][0]=1;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=0;p[6][0]=1;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=2;p[2][2]=0;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=1;p[6][3]=1;p[0][4]=1;p[1][4]=2;p[2][4]=2;
p[3][4]=2;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(33);

///'7'
p[0][0]=1;p[1][0]=2;p[2][0]=2;p[3][0]=2;
p[4][0]=2;p[5][0]=2;p[6][0]=0;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=1;
p[2][2]=1;p[3][2]=1;p[4][2]=2;p[5][2]=0;p[6][2]=1;p[0][3]=1;
p[1][3]=1;p[2][3]=1;p[3][3]=1;p[4][3]=2;p[5][3]=0;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=1;p[3][4]=1;p[4][4]=2;p[5][4]=0;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=2;p[4][5]=0;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=2;
p[4][6]=0;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=1;p[2][7]=1;
p[3][7]=2;p[4][7]=0;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=1;p[3][8]=2;p[4][8]=0;p[5][8]=1;p[6][8]=1;
GetPic(34);

///'8'
p[0][0]=1;
p[1][0]=1;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=0;p[6][0]=1;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=1;p[5][1]=2;
p[6][1]=0;p[0][2]=1;p[1][2]=2;p[2][2]=0;p[3][2]=1;p[4][2]=1;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=1;p[2][4]=2;
p[3][4]=2;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(35);

///'9'
p[0][0]=1;p[1][0]=1;p[2][0]=2;p[3][0]=2;
p[4][0]=2;p[5][0]=0;p[6][0]=1;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=1;p[2][4]=2;p[3][4]=2;p[4][4]=2;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(36);


///'CURSEUR'
p[0][0]=2;
p[1][0]=2;p[2][0]=2;p[3][0]=2;p[4][0]=0;p[5][0]=1;p[6][0]=1;
p[0][1]=2;p[1][1]=2;p[2][1]=2;p[3][1]=2;p[4][1]=0;p[5][1]=1;
p[6][1]=1;p[0][2]=2;p[1][2]=2;p[2][2]=2;p[3][2]=2;p[4][2]=0;
p[5][2]=1;p[6][2]=1;p[0][3]=2;p[1][3]=2;p[2][3]=2;p[3][3]=2;
p[4][3]=0;p[5][3]=1;p[6][3]=1;p[0][4]=2;p[1][4]=2;p[2][4]=2;
p[3][4]=2;p[4][4]=0;p[5][4]=1;p[6][4]=1;p[0][5]=2;p[1][5]=2;
p[2][5]=2;p[3][5]=2;p[4][5]=0;p[5][5]=1;p[6][5]=1;p[0][6]=2;
p[1][6]=2;p[2][6]=2;p[3][6]=2;p[4][6]=0;p[5][6]=1;p[6][6]=1;
p[0][7]=2;p[1][7]=2;p[2][7]=2;p[3][7]=2;p[4][7]=0;p[5][7]=1;
p[6][7]=1;p[0][8]=2;p[1][8]=2;p[2][8]=2;p[3][8]=2;p[4][8]=0;
p[5][8]=1;p[6][8]=1;
GetPic(37);

///'DOT'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=1;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=1;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=1;p[2][3]=1;p[3][3]=1;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=1;p[3][4]=1;p[4][4]=1;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=1;p[4][5]=1;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=1;
p[4][6]=1;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=1;p[2][7]=2;
p[3][7]=2;p[4][7]=0;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=0;p[5][8]=1;p[6][8]=1;
GetPic(38);


///'a'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=2;p[3][3]=2;
p[4][3]=0;p[5][3]=1;p[6][3]=1;p[0][4]=1;p[1][4]=1;p[2][4]=1;
p[3][4]=1;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=1;
p[2][5]=2;p[3][5]=2;p[4][5]=2;p[5][5]=0;p[6][5]=1;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=2;p[5][6]=0;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=2;p[5][7]=0;
p[6][7]=1;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=2;p[6][8]=0;
GetPic(39);

///'b'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=1;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=2;p[2][5]=2;p[3][5]=2;p[4][5]=2;
p[5][5]=0;p[6][5]=1;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=2;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(40);

///'c'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=2;p[3][3]=2;
p[4][3]=2;p[5][3]=0;p[6][3]=1;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(41);

///'d'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=1;p[4][1]=1;p[5][1]=2;p[6][1]=0;p[0][2]=1;p[1][2]=1;
p[2][2]=1;p[3][2]=1;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=1;p[2][3]=1;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=1;p[2][4]=1;p[3][4]=1;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=1;p[2][5]=2;p[3][5]=2;p[4][5]=2;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=2;p[6][8]=0;
GetPic(42);

///'e'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=2;p[3][3]=2;
p[4][3]=2;p[5][3]=0;p[6][3]=1;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=2;
p[2][5]=2;p[3][5]=2;p[4][5]=2;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(43);

///'f'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=2;p[4][1]=2;p[5][1]=0;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=2;p[3][2]=0;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=1;p[2][3]=2;p[3][3]=0;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=2;p[2][4]=2;p[3][4]=2;p[4][4]=0;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=2;p[3][5]=0;p[4][5]=1;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=1;p[2][6]=2;p[3][6]=0;
p[4][6]=1;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=1;p[2][7]=2;
p[3][7]=0;p[4][7]=1;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=0;p[4][8]=1;p[5][8]=1;p[6][8]=1;
GetPic(44);

///'g'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=2;p[3][2]=2;p[4][2]=2;
p[5][2]=0;p[6][2]=1;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=1;
p[2][5]=2;p[3][5]=2;p[4][5]=2;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=1;p[2][7]=1;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(45);

///'h'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=2;
p[3][1]=0;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=2;p[3][2]=0;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=1;p[2][3]=2;p[3][3]=0;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=2;p[3][4]=2;p[4][4]=2;p[5][4]=0;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=2;p[3][5]=0;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=1;p[2][6]=2;p[3][6]=0;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=1;p[2][7]=2;
p[3][7]=0;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=0;p[4][8]=1;p[5][8]=2;p[6][8]=0;
GetPic(46);

///'i'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=2;
p[4][0]=0;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=1;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=1;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=1;p[2][3]=1;p[3][3]=2;p[4][3]=0;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=1;p[3][4]=2;p[4][4]=0;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=2;p[4][5]=0;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=2;
p[4][6]=0;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=1;p[2][7]=1;
p[3][7]=2;p[4][7]=0;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=1;p[3][8]=2;p[4][8]=0;p[5][8]=1;p[6][8]=1;
GetPic(47);

///'j'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=2;p[6][0]=0;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=1;p[2][3]=1;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=1;p[2][4]=1;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=1;
p[2][5]=1;p[3][5]=1;p[4][5]=1;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=1;p[2][7]=2;p[3][7]=0;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=1;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(48);

///'k'
p[0][0]=1;p[1][0]=2;p[2][0]=0;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=2;p[2][1]=0;
p[3][1]=1;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=2;
p[2][2]=0;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=2;p[5][4]=0;
p[6][4]=1;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=2;p[4][5]=0;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=2;p[2][6]=2;p[3][6]=0;
p[4][6]=1;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=2;p[4][7]=0;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=2;
p[2][8]=0;p[3][8]=1;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(49);

///'l'
p[0][0]=1;p[1][0]=1;p[2][0]=2;p[3][0]=0;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=2;
p[3][1]=0;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=2;p[3][2]=0;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=1;p[2][3]=2;p[3][3]=0;p[4][3]=1;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=2;p[3][4]=0;p[4][4]=1;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=2;p[3][5]=0;p[4][5]=1;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=1;p[2][6]=2;p[3][6]=0;
p[4][6]=1;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=1;p[2][7]=2;
p[3][7]=0;p[4][7]=1;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=0;p[4][8]=1;p[5][8]=1;p[6][8]=1;
GetPic(50);

///'m'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=2;p[2][3]=2;p[3][3]=2;
p[4][3]=2;p[5][3]=0;p[6][3]=1;p[0][4]=2;p[1][4]=0;p[2][4]=1;
p[3][4]=2;p[4][4]=0;p[5][4]=2;p[6][4]=0;p[0][5]=2;p[1][5]=0;
p[2][5]=1;p[3][5]=2;p[4][5]=0;p[5][5]=2;p[6][5]=0;p[0][6]=2;
p[1][6]=0;p[2][6]=1;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=2;p[1][7]=0;p[2][7]=1;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=2;p[1][8]=0;p[2][8]=1;p[3][8]=1;p[4][8]=1;
p[5][8]=2;p[6][8]=0;
GetPic(51);

///'n'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=1;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=1;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=2;p[3][3]=2;p[4][3]=2;p[5][3]=0;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=2;p[3][4]=0;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=1;p[2][5]=2;p[3][5]=0;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=1;p[2][6]=2;p[3][6]=0;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=1;p[2][7]=2;
p[3][7]=0;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=0;p[4][8]=1;p[5][8]=2;p[6][8]=0;
GetPic(52);

///'o'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=2;p[3][3]=2;
p[4][3]=2;p[5][3]=0;p[6][3]=1;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=1;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(53);
///'p'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=1;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=2;
p[2][2]=2;p[3][2]=2;p[4][2]=2;p[5][2]=0;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=2;p[2][5]=2;p[3][5]=2;p[4][5]=2;
p[5][5]=0;p[6][5]=1;p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;
p[4][6]=1;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=2;p[2][7]=0;
p[3][7]=1;p[4][7]=1;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=2;
p[2][8]=0;p[3][8]=1;p[4][8]=1;p[5][8]=1;p[6][8]=1;
GetPic(54);

///'q'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=2;p[3][2]=2;p[4][2]=2;
p[5][2]=2;p[6][2]=0;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=1;
p[2][5]=2;p[3][5]=2;p[4][5]=2;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=1;p[4][6]=1;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=1;p[2][7]=1;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=1;p[3][8]=1;p[4][8]=1;
p[5][8]=2;p[6][8]=0;
GetPic(55);

///'r'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=1;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=1;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=1;p[2][3]=2;p[3][3]=0;p[4][3]=2;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=1;p[2][4]=2;p[3][4]=2;p[4][4]=0;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=2;p[3][5]=0;p[4][5]=1;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=1;p[2][6]=2;p[3][6]=0;
p[4][6]=1;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=1;p[2][7]=2;
p[3][7]=0;p[4][7]=1;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=2;p[3][8]=0;p[4][8]=1;p[5][8]=1;p[6][8]=1;
GetPic(56);

///'s'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=2;p[3][3]=2;
p[4][3]=2;p[5][3]=0;p[6][3]=1;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=2;
p[2][5]=2;p[3][5]=2;p[4][5]=0;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=1;p[4][6]=2;p[5][6]=0;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=0;p[6][8]=1;
GetPic(57);

///'t'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=2;
p[4][0]=0;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=2;p[4][1]=0;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=2;
p[2][2]=2;p[3][2]=2;p[4][2]=2;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=1;p[2][3]=1;p[3][3]=2;p[4][3]=0;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=1;p[3][4]=2;p[4][4]=0;p[5][4]=1;
p[6][4]=1;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=2;p[4][5]=0;
p[5][5]=1;p[6][5]=1;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=2;
p[4][6]=0;p[5][6]=1;p[6][6]=1;p[0][7]=1;p[1][7]=1;p[2][7]=1;
p[3][7]=2;p[4][7]=0;p[5][7]=1;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=1;p[3][8]=2;p[4][8]=0;p[5][8]=1;p[6][8]=1;
GetPic(58);

///'u'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=2;p[5][3]=0;p[6][3]=1;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=1;p[4][5]=2;p[5][5]=0;p[6][5]=1;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=2;p[5][6]=0;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=2;p[5][7]=0;
p[6][7]=1;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=2;p[6][8]=0;
GetPic(59);

///'v'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=1;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=1;p[3][2]=1;p[4][2]=1;p[5][2]=1;p[6][2]=1;p[0][3]=1;
p[1][3]=2;p[2][3]=0;p[3][3]=1;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=2;p[2][4]=0;p[3][4]=1;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=2;p[2][5]=0;p[3][5]=1;p[4][5]=1;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=1;p[2][6]=2;p[3][6]=0;
p[4][6]=2;p[5][6]=0;p[6][6]=1;p[0][7]=1;p[1][7]=1;p[2][7]=2;
p[3][7]=0;p[4][7]=2;p[5][7]=0;p[6][7]=1;p[0][8]=1;p[1][8]=1;
p[2][8]=1;p[3][8]=2;p[4][8]=0;p[5][8]=1;p[6][8]=1;
GetPic(60);

///'w'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=2;p[2][4]=0;
p[3][4]=1;p[4][4]=1;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=2;
p[2][5]=0;p[3][5]=2;p[4][5]=0;p[5][5]=2;p[6][5]=0;p[0][6]=1;
p[1][6]=2;p[2][6]=0;p[3][6]=2;p[4][6]=0;p[5][6]=2;p[6][6]=0;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=2;p[4][7]=0;p[5][7]=2;
p[6][7]=0;p[0][8]=1;p[1][8]=1;p[2][8]=2;p[3][8]=0;p[4][8]=2;
p[5][8]=0;p[6][8]=2;
GetPic(61);

///'x'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=2;p[2][3]=0;p[3][3]=1;
p[4][3]=1;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=1;p[2][4]=2;
p[3][4]=0;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=1;
p[2][5]=1;p[3][5]=2;p[4][5]=0;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=2;p[4][6]=0;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=1;p[2][7]=2;p[3][7]=0;p[4][7]=2;p[5][7]=0;
p[6][7]=1;p[0][8]=1;p[1][8]=2;p[2][8]=0;p[3][8]=1;p[4][8]=1;
p[5][8]=2;p[6][8]=0;
GetPic(62);

///'y'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;
p[4][0]=1;p[5][0]=1;p[6][0]=1;p[0][1]=1;p[1][1]=1;p[2][1]=1;
p[3][1]=1;p[4][1]=1;p[5][1]=1;p[6][1]=1;p[0][2]=1;p[1][2]=1;
p[2][2]=2;p[3][2]=0;p[4][2]=1;p[5][2]=2;p[6][2]=0;p[0][3]=1;
p[1][3]=1;p[2][3]=2;p[3][3]=0;p[4][3]=1;p[5][3]=2;p[6][3]=0;
p[0][4]=1;p[1][4]=1;p[2][4]=2;p[3][4]=0;p[4][4]=1;p[5][4]=2;
p[6][4]=0;p[0][5]=1;p[1][5]=1;p[2][5]=1;p[3][5]=2;p[4][5]=2;
p[5][5]=2;p[6][5]=0;p[0][6]=1;p[1][6]=1;p[2][6]=1;p[3][6]=1;
p[4][6]=1;p[5][6]=2;p[6][6]=0;p[0][7]=1;p[1][7]=1;p[2][7]=2;
p[3][7]=0;p[4][7]=1;p[5][7]=2;p[6][7]=0;p[0][8]=1;p[1][8]=1;
p[2][8]=1;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(63);

///'z'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=2;p[2][3]=2;p[3][3]=2;
p[4][3]=2;p[5][3]=2;p[6][3]=0;p[0][4]=1;p[1][4]=1;p[2][4]=1;
p[3][4]=1;p[4][4]=2;p[5][4]=0;p[6][4]=1;p[0][5]=1;p[1][5]=1;
p[2][5]=1;p[3][5]=2;p[4][5]=0;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=2;p[3][6]=0;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=2;p[2][8]=2;p[3][8]=2;p[4][8]=2;
p[5][8]=2;p[6][8]=0;
GetPic(64);

///'+'
p[0][0]=1;
p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=2;p[4][2]=0;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=1;p[3][3]=2;
p[4][3]=0;p[5][3]=1;p[6][3]=1;p[0][4]=1;p[1][4]=2;p[2][4]=2;
p[3][4]=2;p[4][4]=2;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=1;
p[2][5]=1;p[3][5]=2;p[4][5]=0;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=2;p[4][6]=0;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=1;p[2][7]=1;p[3][7]=1;p[4][7]=1;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=1;p[2][8]=1;p[3][8]=1;p[4][8]=1;
p[5][8]=1;p[6][8]=1;
GetPic(65);

///'-'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=1;p[5][1]=1;
p[6][1]=1;p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=1;
p[5][2]=1;p[6][2]=1;p[0][3]=1;p[1][3]=1;p[2][3]=1;p[3][3]=1;
p[4][3]=1;p[5][3]=1;p[6][3]=1;p[0][4]=1;p[1][4]=2;p[2][4]=2;
p[3][4]=2;p[4][4]=2;p[5][4]=2;p[6][4]=0;p[0][5]=1;p[1][5]=1;
p[2][5]=1;p[3][5]=1;p[4][5]=1;p[5][5]=1;p[6][5]=1;p[0][6]=1;
p[1][6]=1;p[2][6]=1;p[3][6]=1;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=1;p[2][7]=1;p[3][7]=1;p[4][7]=1;p[5][7]=1;
p[6][7]=1;p[0][8]=1;p[1][8]=1;p[2][8]=1;p[3][8]=1;p[4][8]=1;
p[5][8]=1;p[6][8]=1;
GetPic(66);

///'/'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=1;p[3][1]=1;p[4][1]=2;p[5][1]=0;p[6][1]=1;
p[0][2]=1;p[1][2]=1;p[2][2]=1;p[3][2]=1;p[4][2]=2;p[5][2]=0;p[6][2]=1;
p[0][3]=1;p[1][3]=1;p[2][3]=1;p[3][3]=2;p[4][3]=0;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=2;p[3][4]=0;p[4][4]=1;p[5][4]=1;p[6][4]=1;
p[0][5]=1;p[1][5]=1;p[2][5]=2;p[3][5]=0;p[4][5]=1;p[5][5]=1;p[6][5]=1;
p[0][6]=1;p[1][6]=2;p[2][6]=0;p[3][6]=1;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=2;p[1][7]=0;p[2][7]=1;p[3][7]=1;p[4][7]=1;p[5][7]=1;p[6][7]=1;
p[0][8]=2;p[1][8]=0;p[2][8]=1;p[3][8]=1;p[4][8]=1;p[5][8]=1;p[6][8]=1;
GetPic(67);

///':'
p[0][0]=1;p[1][0]=1;p[2][0]=1;p[3][0]=1;p[4][0]=1;p[5][0]=1;p[6][0]=1;
p[0][1]=1;p[1][1]=1;p[2][1]=2;p[3][1]=2;p[4][1]=1;p[5][1]=1;p[6][1]=1;
p[0][2]=1;p[1][2]=1;p[2][2]=2;p[3][2]=2;p[4][2]=0;p[5][2]=1;p[6][2]=1;
p[0][3]=1;p[1][3]=1;p[2][3]=1;p[3][3]=0;p[4][3]=0;p[5][3]=1;p[6][3]=1;
p[0][4]=1;p[1][4]=1;p[2][4]=1;p[3][4]=1;p[4][4]=1;p[5][4]=1;p[6][4]=1;
p[0][5]=1;p[1][5]=1;p[2][5]=2;p[3][5]=2;p[4][5]=1;p[5][5]=1;p[6][5]=1;
p[0][6]=1;p[1][6]=1;p[2][6]=2;p[3][6]=2;p[4][6]=0;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=1;p[2][7]=1;p[3][7]=0;p[4][7]=0;p[5][7]=1;p[6][7]=1;
p[0][8]=1;p[1][8]=1;p[2][8]=1;p[3][8]=1;p[4][8]=1;p[5][8]=1;p[6][8]=1;
GetPic(68);

///'@'
p[0][0]=1;p[1][0]=1;p[2][0]=2;p[3][0]=2;p[4][0]=2;p[5][0]=0;p[6][0]=1;
p[0][1]=1;p[1][1]=2;p[2][1]=0;p[3][1]=1;p[4][1]=0;p[5][1]=2;p[6][1]=0;
p[0][2]=2;p[1][2]=0;p[2][2]=1;p[3][2]=2;p[4][2]=2;p[5][2]=0;p[6][2]=2;
p[0][3]=2;p[1][3]=0;p[2][3]=2;p[3][3]=0;p[4][3]=1;p[5][3]=1;p[6][3]=2;
p[0][4]=2;p[1][4]=0;p[2][4]=2;p[3][4]=0;p[4][4]=1;p[5][4]=2;p[6][4]=2;
p[0][5]=2;p[1][5]=0;p[2][5]=1;p[3][5]=2;p[4][5]=2;p[5][5]=0;p[6][5]=2;
p[0][6]=2;p[1][6]=0;p[2][6]=1;p[3][6]=1;p[4][6]=1;p[5][6]=1;p[6][6]=1;
p[0][7]=1;p[1][7]=2;p[2][7]=0;p[3][7]=1;p[4][7]=1;p[5][7]=2;p[6][7]=0;
p[0][8]=1;p[1][8]=0;p[2][8]=2;p[3][8]=2;p[4][8]=2;p[5][8]=0;p[6][8]=1;
GetPic(69);

int uu=0;
for (uu=0;uu<70;uu++){WidjetZoomSurface(Size,&Structure->FontPic[uu]);}
int rep=0;
for (rep=0;rep<70;rep++){
SDL_SetColorKey(Structure->FontPic[rep], SDL_SRCCOLORKEY, SDL_MapRGB(Structure->FontPic[rep]->format, 255, 0,0 ) );
}
}

void WidjetText(int x,int y,char *text,Widjet *Structure){
SDL_Rect position;
position.x=x;
position.y=y;
int tt=0;
int sp=Structure->FontPic[0]->w;
while (text[tt]!='\0'){
if (text[tt]=='\0')  {return;}
if (text[tt]=='A') {
draw(1,sp);
}else if (text[tt]=='B')  {
draw(2,sp);
}else if (text[tt]=='C')  {
draw(3,sp);
}else if  (text[tt]=='D')  {
draw(4,sp);
}else if (text[tt]=='E')  {
draw(5,sp);
}else if  (text[tt]=='F')  {
draw(6,sp);
}else if  (text[tt]=='G')  {
draw(7,sp);
}else if  (text[tt]=='H')  {
draw(8,sp);
}else if (text[tt]=='I')  {
draw(9,sp);
}else if  (text[tt]=='J')  {
draw(10,sp);
}else if  (text[tt]=='K')  {
draw(11,sp);
}else if  (text[tt]=='L')  {
draw(12,sp);
}else if  (text[tt]=='M')  {
draw(13,sp);
}else if (text[tt]=='N')  {
draw(14,sp);
}else if (text[tt]=='O')  {
draw(15,sp);
}else if (text[tt]=='P') {
draw(16,sp);
}else if  (text[tt]=='Q')  {
draw(17,sp);
}else if (text[tt]=='R') {
draw(18,sp);
}else if  (text[tt]=='S')  {
draw(19,sp);
}else if (text[tt]=='T') {
draw(20,sp);
}else if  (text[tt]=='U')  {
draw(21,sp);
}else if  (text[tt]=='V')  {
draw(22,sp);
}else if (text[tt]=='W')  {
draw(23,sp);
}else if (text[tt]=='X')  {
draw(24,sp);
}else if  (text[tt]=='Y')  {
draw(25,sp);
}else if (text[tt]=='Z')  {
draw(26,sp);
}else if (text[tt]=='0')  {
draw(27,sp);
}else if (text[tt]=='1')  {
draw(28,sp);
}else if (text[tt]=='2')  {
draw(29,sp);
}else if (text[tt]=='3')  {
draw(30,sp);
}else if (text[tt]=='4')  {
draw(31,sp);
}else if (text[tt]=='5')  {
draw(32,sp);
}else if (text[tt]=='6')  {
draw(33,sp);
}else if (text[tt]=='7')  {
draw(34,sp);
}else if (text[tt]=='8')  {
draw(35,sp);
}else if (text[tt]=='9')  {
draw(36,sp);
}else if (text[tt]=='.')  {
draw(38,sp);
}else if (text[tt]=='a')  {
draw(39,sp);
}else if (text[tt]=='b')  {
draw(40,sp);
}else if (text[tt]=='c')  {
draw(41,sp);
}else if  (text[tt]=='d')  {
draw(42,sp);
}else if (text[tt]=='e')  {
draw(43,sp);
}else if  (text[tt]=='f')  {
draw(44,sp);
}else if  (text[tt]=='g')  {
draw(45,sp);
}else if  (text[tt]=='h')  {
draw(46,sp);
}else if (text[tt]=='i')  {
draw(47,sp);
}else if  (text[tt]=='j')  {
draw(48,sp);
}else if  (text[tt]=='k')  {
draw(49,sp);
}else if  (text[tt]=='l')  {
draw(50,sp);
}else if  (text[tt]=='m')  {
draw(51,sp);
}else if (text[tt]=='n')  {
draw(52,sp);
}else if (text[tt]=='o')  {
draw(53,sp);
}else if (text[tt]=='p') {
draw(54,sp);
}else if  (text[tt]=='q')  {
draw(55,sp);
}else if (text[tt]=='r') {
draw(56,sp);
}else if  (text[tt]=='s')  {
draw(57,sp);
}else if (text[tt]=='t') {
draw(58,sp);
}else if  (text[tt]=='u')  {
draw(59,sp);
}else if  (text[tt]=='v')  {
draw(60,sp);
}else if (text[tt]=='w')  {
draw(61,sp);
}else if (text[tt]=='x')  {
draw(62,sp);
}else if  (text[tt]=='y')  {
draw(63,sp);
}else if (text[tt]=='z')  {
draw(64,sp);
}else if (text[tt]=='+')  {
draw(65,sp);
}else if (text[tt]=='-')  {
draw(66,sp);
}else if (text[tt]=='/')  {
draw(67,sp);
}else if (text[tt]==':')  {
draw(68,sp);
}else if (text[tt]=='@')  {
draw(69,sp);
}else{
draw(0,sp);
}
tt++;
}
}


void UpdateEvents(Input* in){
SDL_Event event;
while(SDL_PollEvent(&event))
{
switch (event.type)
{
case SDL_KEYDOWN:
in->key[event.key.keysym.sym]=1;
break;
case SDL_KEYUP:
in->key[event.key.keysym.sym]=0;
break;
case SDL_MOUSEMOTION:
in->mousex=event.motion.x;
in->mousey=event.motion.y;
in->mousexrel=event.motion.xrel;
in->mouseyrel=event.motion.yrel;
break;
case SDL_MOUSEBUTTONDOWN:
in->mousebuttons[event.button.button]=1;
break;
case SDL_MOUSEBUTTONUP:
in->mousebuttons[event.button.button]=0;
break;
case SDL_QUIT:
in->quit = 1;
break;
default:
break;
}}
}

void WidjetInit(Widjet *Structure){
WidjetGetPic(Structure);
WidjetGetFont(DEFAULT,DEFAULT,DEFAULT,Structure);
memset(&Structure->Event,0,sizeof(Structure->Event));
Structure->ColorFond=WidjetRGB(200,200,200);
Structure->ColorSurvole=WidjetRGB(220,220,220);
Structure->ColorOmbre=WidjetRGB(0,0,0);
Structure->ColorLumiere=WidjetRGB(255,255,255);
Structure->ColorClic=WidjetRGB(175,175,175);
Structure->ColorProgress=WidjetRGB(0,155,255);
Structure->WidjetTimer1=0;
Structure->ZoneCheckx=0;
Structure->ZoneChecky=0;
Structure->radiobutton[0]=-1;
Structure->radiobutton[1]=-1;
}
Uint32 WidjetRGB(Uint32 Red,Uint32 Green,Uint32 Blue){
return (Blue+(Green*256)+(Red*256*256));
}
Uint32 WidjetRed(Uint32 Color){
int rouge = Color & 0xFF0000;
return rouge/256/256;
}
Uint32 WidjetGreen(Uint32 Color){
int vert =  Color & 0x00FF00;
return vert/256;
}
Uint32 WidjetBlue(Uint32 Color){
int blue =Color & 0x0000FF;
return blue;
}

void putpixel(SDL_Surface *surface, int x, int y, Uint32 pixel)
{
if (((x<surface->w) && (x>=0)) &&((y<surface->h) && (y>=0))) {
 int Bytes=0;
Bytes = surface->format->BytesPerPixel;
Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * Bytes;
switch(Bytes) {
case 1:
*p = pixel;
break;
case 2:
*(Uint16 *)p = pixel;
break;
case 3:
if(SDL_BYTEORDER == SDL_BIG_ENDIAN) {
p[0] = (pixel >> 16) & 0xff;
p[1] = (pixel >> 8) & 0xff;
p[2] = pixel & 0xff;
} else {
p[0] = pixel & 0xff;
p[1] = (pixel >> 8) & 0xff;
p[2] = (pixel >> 16) & 0xff;
}
break;
case 4:
*(Uint32 *)p = pixel;
break;
}}
}

Uint32 getpixel(SDL_Surface *surface, int x, int y)
{
//overflow detect
if (((x<surface->w) && (x>=0)) &&((y<surface->h) && (y>=0))) {
int bpp = surface->format->BytesPerPixel;
Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;
switch(bpp) {
    case 1:
        return *p;
        break;

    case 2:
        return *(Uint16 *)p;
        break;

    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
            return p[0] << 16 | p[1] << 8 | p[2];
        else
            return p[0] | p[1] << 8 | p[2] << 16;
        break;

    case 4:
        return *(Uint32 *)p;
        break;

    default:
        return 0; 
    }
}else{return 0;}
}

int WidjetRadioButton(int wx,int wy,char Text[255],Widjet *Structure){
if ((Structure->radiobutton[0]==-1)&&(Structure->radiobutton[1]==-1)) {Structure->radiobutton[0]=wx;Structure->radiobutton[1]=wy;}
	
SDL_Rect position;
position.x=wx;
position.y=wy;
if ((Structure->Event.mousex>=wx)&&(Structure->Event.mousex<=(wx+10))&&(Structure->Event.mousey>=wy)&&(Structure->Event.mousey<=wy+10)&&(Structure->Event.mousebuttons[SDL_BUTTON_LEFT]==1)) {
Structure->Event.mousebuttons[SDL_BUTTON_LEFT]=0;
Structure->ZoneCheckx=wx;
Structure->ZoneChecky=wy;
Structure->radiobutton[0]=wx;
Structure->radiobutton[1]=wy;
}

if ((Structure->radiobutton[0]==wx)&&(Structure->radiobutton[1]==wy)) {
SDL_BlitSurface(Structure->Pic[11],0,Structure->render,&position);
SDL_BlitSurface(Structure->Pic[12],0,Structure->render,&position);
WidjetText(wx+11,(wy)+(round((10-(Structure->FontPic[0]->h))/2)),&Text[0],Structure);
return 1;
}else{
SDL_BlitSurface(Structure->Pic[11],0,Structure->render,&position);
WidjetText(wx+11,(wy)+(round((10-(Structure->FontPic[0]->h))/2)),&Text[0],Structure);
return 0;
}
}


int WidjetCheckBox(int wx,int wy,char Text[255],int *Checked,Widjet *Structure){
SDL_Rect position;
position.x=wx;
position.y=wy;
if ((Structure->Event.mousex>=wx)&&(Structure->Event.mousex<=(wx+10))&&(Structure->Event.mousey>=wy)&&(Structure->Event.mousey<=wy+10)&&(Structure->Event.mousebuttons[SDL_BUTTON_LEFT]==1)) {
Structure->Event.mousebuttons[SDL_BUTTON_LEFT]=0;
Structure->ZoneCheckx=wx;
Structure->ZoneChecky=wy;
if (*Checked==0) {
*Checked=1;
}else{
*Checked=0;
}}
if (*Checked==0) {
SDL_BlitSurface(Structure->Pic[9],0,Structure->render,&position);
}else{
SDL_BlitSurface(Structure->Pic[10],0,Structure->render,&position);
}
WidjetText(wx+11,(wy)+(round((10-(Structure->FontPic[0]->h))/2)),&Text[0],Structure);
if (*Checked==0) {return 0;}else{return 1;}
}


Uint32 WidjetTimer(Uint32 Delayms,Uint32 *VariableDeComparaison){
if ((SDL_GetTicks())-*VariableDeComparaison>=Delayms) {*VariableDeComparaison=SDL_GetTicks();}
if ((SDL_GetTicks())-*VariableDeComparaison<=Delayms/2){
return 1;
}else
return 0;
}

Uint32 WidjetTimerTrigger(Uint32 Delayms,Uint32 *VariableDeComparaison){
if ((SDL_GetTicks())-*VariableDeComparaison>=Delayms) {*VariableDeComparaison=SDL_GetTicks();return 1;}else{return 0;}

}

void WidjetGetPic(Widjet *Structure){
	int x,y,t;
	for (t=0;t<13;t++) {SDL_FreeSurface(Structure->Pic[t]);}
	// memoire libre pour bmp widjet
	Structure->Pic[0]=SDL_CreateRGBSurface(SDL_SWSURFACE,1,1,32,0,0,0,0);
	Structure->Pic[1]=SDL_CreateRGBSurface(SDL_SWSURFACE,1,1,32,0,0,0,0);
	Structure->Pic[2]=SDL_CreateRGBSurface(SDL_SWSURFACE,1,1,32,0,0,0,0);
	// fin memoire libre
	
int p[17][17];
x=0;y=0;
for (y=0;y<17;y++){
for (x=0;x<17;x++){
p[x][y]=0;
}}
x=0;y=0;
p[0][0]=16777215;
p[1][0]=16777215;p[2][0]=16777215;p[3][0]=16777215;p[4][0]=16777215;p[0][1]=16777215;p[1][1]=0;
p[2][1]=16777215;p[3][1]=0;p[4][1]=16777215;p[0][2]=16777215;p[1][2]=0;p[2][2]=16777215;
p[3][2]=0;p[4][2]=16777215;p[0][3]=10526880;p[1][3]=5789784;p[2][3]=16777215;p[3][3]=5789784;
p[4][3]=10526880;p[0][4]=0;p[1][4]=14474460;p[2][4]=16777215;p[3][4]=14474460;p[4][4]=0;
p[0][5]=0;p[1][5]=14474460;p[2][5]=16777215;p[3][5]=14474460;p[4][5]=0;p[0][6]=0;
p[1][6]=14474460;p[2][6]=16777215;p[3][6]=14474460;p[4][6]=0;p[0][7]=0;p[1][7]=14474460;
p[2][7]=16777215;p[3][7]=14474460;p[4][7]=0;p[0][8]=10526880;p[1][8]=5789784;p[2][8]=16777215;
p[3][8]=5789784;p[4][8]=10526880;p[0][9]=16777215;p[1][9]=0;p[2][9]=16777215;p[3][9]=0;
p[4][9]=16777215;p[0][10]=16777215;p[1][10]=0;p[2][10]=16777215;p[3][10]=0;p[4][10]=16777215;
p[0][11]=16777215;p[1][11]=16777215;p[2][11]=16777215;p[3][11]=16777215;p[4][11]=16777215;
Structure->Pic[3]=SDL_CreateRGBSurface(SDL_HWSURFACE,5,12,32,0,0,0,0);
SDL_LockSurface(Structure->Pic[3]);
for (y=0;y<12;y++){
for (x=0;x<5;x++){
putpixel(Structure->Pic[3], x, y,(p[x][y]));
}}
SDL_UnlockSurface(Structure->Pic[3]);

x=0;y=0;
for (y=0;y<17;y++){
for (x=0;x<17;x++){
p[x][y]=0;
}}
x=0;y=0;
p[0][0]=462101;p[0][1]=4617382;p[0][2]=9416658;p[0][3]=12963028;p[0][4]=14935001;p[0][5]=16514041;p[0][6]=16514042;
p[0][7]=14935002;p[0][8]=12963028;p[0][9]=9482193;p[0][10]=4683175;p[0][11]=462357;
Structure->Pic[4]=SDL_CreateRGBSurface(SDL_HWSURFACE,1,12,32,0,0,0,0);
SDL_LockSurface(Structure->Pic[4]);
for (y=0;y<12;y++){
putpixel(Structure->Pic[4], 0, y,(p[0][y]));
}
SDL_UnlockSurface(Structure->Pic[4]);
x=0;y=0;
for (y=0;y<17;y++){
for (x=0;x<17;x++){
p[x][y]=0;
}}
x=0;y=0;
p[0][0]=16777215;
p[1][0]=16777215;p[2][0]=0;p[3][0]=0;p[4][0]=0;p[5][0]=0;p[6][0]=0;
p[7][0]=0;p[8][0]=0;p[9][0]=0;p[10][0]=0;p[11][0]=0;p[12][0]=0;
p[13][0]=0;p[14][0]=16777215;p[15][0]=16777215;p[0][1]=16777215;p[1][1]=0;p[2][1]=11067359;
p[3][1]=12648447;p[4][1]=12648447;p[5][1]=12648447;p[6][1]=9699327;p[7][1]=2949119;p[8][1]=65535;
p[9][1]=65535;p[10][1]=65535;p[11][1]=65535;p[12][1]=65535;p[13][1]=57568;p[14][1]=0;
p[15][1]=16777215;p[0][2]=0;p[1][2]=5282282;p[2][2]=6533119;p[3][2]=10146815;p[4][2]=11066623;
p[5][2]=11066623;p[6][2]=11396095;p[7][2]=12252927;p[8][2]=12648447;p[9][2]=12648447;p[10][2]=9961471;
p[11][2]=2555903;p[12][2]=65535;p[13][2]=65535;p[14][2]=60395;p[15][2]=0;p[0][3]=0;
p[1][3]=30186;p[2][3]=820735;p[3][3]=5745407;p[4][3]=10015487;p[5][3]=11066623;p[6][3]=11066623;
p[7][3]=11066623;p[8][3]=11066623;p[9][3]=11066623;p[10][3]=11330559;p[11][3]=12253183;p[12][3]=10682367;
p[13][3]=1769471;p[14][3]=60395;p[15][3]=0;p[0][4]=0;p[1][4]=3306;p[2][4]=28927;
p[3][4]=1017599;p[4][4]=5679871;p[5][4]=9949695;p[6][4]=11066623;p[7][4]=11066623;p[8][4]=11066623;
p[9][4]=11066623;p[10][4]=11066623;p[11][4]=11066623;p[12][4]=11264511;p[13][4]=10877695;p[14][4]=1305579;
p[15][4]=0;p[0][5]=0;p[1][5]=3306;p[2][5]=28927;p[3][5]=33023;p[4][5]=33023;
p[5][5]=1280255;p[6][5]=4431615;p[7][5]=5810431;p[8][5]=5810431;p[9][5]=5810431;p[10][5]=5810431;
p[11][5]=5810431;p[12][5]=6862335;p[13][5]=11662079;p[14][5]=11594731;p[15][5]=0;p[0][6]=16777215;
p[1][6]=0;p[2][6]=223;p[3][6]=255;p[4][6]=6655;p[5][6]=25855;p[6][6]=33023;
p[7][6]=33023;p[8][6]=33023;p[9][6]=33023;p[10][6]=33023;p[11][6]=33023;p[12][6]=33023;
p[13][6]=28896;p[14][6]=0;p[15][6]=16777215;p[0][7]=16777215;p[1][7]=16777215;p[2][7]=0;
p[3][7]=0;p[4][7]=0;p[5][7]=0;p[6][7]=0;p[7][7]=0;p[8][7]=0;
p[9][7]=0;p[10][7]=0;p[11][7]=0;p[12][7]=0;p[13][7]=0;p[14][7]=16777215;
p[15][7]=16777215;
Structure->Pic[5]=SDL_CreateRGBSurface(SDL_HWSURFACE,16,8,32,0,0,0,0);

SDL_LockSurface(Structure->Pic[5]);
for (y=0;y<8;y++){
for (x=0;x<16;x++){
putpixel(Structure->Pic[5], x, y,(p[x][y]));
}}
SDL_UnlockSurface(Structure->Pic[5]);

// memoire libre
Structure->Pic[6]=SDL_CreateRGBSurface(SDL_HWSURFACE,1,1,32,0,0,0,0);
Structure->Pic[7]=SDL_CreateRGBSurface(SDL_HWSURFACE,1,1,32,0,0,0,0);
Structure->Pic[8]=SDL_CreateRGBSurface(SDL_HWSURFACE,1,1,32,0,0,0,0);
//fin memoire libre	

x=0;y=0;
for (y=0;y<17;y++){
for (x=0;x<17;x++){
	p[x][y]=0;
}}
x=0;y=0;

p[0][0]=16777215;
p[1][0]=16777215;p[2][0]=16777215;p[3][0]=16777215;p[4][0]=16777215;p[5][0]=16777215;p[6][0]=16777215;
p[7][0]=16777215;p[8][0]=16777215;p[9][0]=16777215;p[0][1]=16777215;p[1][1]=14474460;p[2][1]=14474460;
p[3][1]=14474460;p[4][1]=14474460;p[5][1]=14474460;p[6][1]=14474460;p[7][1]=14474460;p[8][1]=14474460;
p[9][1]=0;p[0][2]=16777215;p[1][2]=14474460;p[2][2]=14474460;p[3][2]=14474460;p[4][2]=14474460;
p[5][2]=14474460;p[6][2]=14474460;p[7][2]=14474460;p[8][2]=14474460;p[9][2]=0;p[0][3]=16777215;
p[1][3]=14474460;p[2][3]=14474460;p[3][3]=14474460;p[4][3]=14474460;p[5][3]=14474460;p[6][3]=14474460;
p[7][3]=14474460;p[8][3]=14474460;p[9][3]=0;p[0][4]=16777215;p[1][4]=14474460;p[2][4]=14474460;
p[3][4]=14474460;p[4][4]=14474460;p[5][4]=14474460;p[6][4]=14474460;p[7][4]=14474460;p[8][4]=14474460;
p[9][4]=0;p[0][5]=16777215;p[1][5]=14474460;p[2][5]=14474460;p[3][5]=14474460;p[4][5]=14474460;
p[5][5]=14474460;p[6][5]=14474460;p[7][5]=14474460;p[8][5]=14474460;p[9][5]=0;p[0][6]=16777215;
p[1][6]=14474460;p[2][6]=14474460;p[3][6]=14474460;p[4][6]=14474460;p[5][6]=14474460;p[6][6]=14474460;
p[7][6]=14474460;p[8][6]=14474460;p[9][6]=0;p[0][7]=16777215;p[1][7]=14474460;p[2][7]=14474460;
p[3][7]=14474460;p[4][7]=14474460;p[5][7]=14474460;p[6][7]=14474460;p[7][7]=14474460;p[8][7]=14474460;
p[9][7]=0;p[0][8]=16777215;p[1][8]=14474460;p[2][8]=14474460;p[3][8]=14474460;p[4][8]=14474460;
p[5][8]=14474460;p[6][8]=14474460;p[7][8]=14474460;p[8][8]=14474460;p[9][8]=0;p[0][9]=16777215;
p[1][9]=0;p[2][9]=0;p[3][9]=0;p[4][9]=0;p[5][9]=0;p[6][9]=0;
p[7][9]=0;p[8][9]=0;p[9][9]=0;
Structure->Pic[9]=SDL_CreateRGBSurface(SDL_HWSURFACE,10,10,32,0,0,0,0);

SDL_LockSurface(Structure->Pic[9]);
for (y=0;y<10;y++){
for (x=0;x<10;x++){
putpixel(Structure->Pic[9], x, y,(p[x][y]));
}}
SDL_UnlockSurface(Structure->Pic[9]);

x=0;y=0;
for (y=0;y<17;y++){
for (x=0;x<17;x++){
p[x][y]=0;
}}
x=0;y=0;

p[0][0]=16777215;p[1][0]=16777215;p[2][0]=16777215;
p[3][0]=16777215;p[4][0]=16777215;p[5][0]=16777215;p[6][0]=16777215;p[7][0]=16777215;p[8][0]=16777215;
p[9][0]=16777215;p[0][1]=16777215;p[1][1]=14474460;p[2][1]=14474460;p[3][1]=14474460;p[4][1]=14474460;
p[5][1]=14474460;p[6][1]=14474460;p[7][1]=14474460;p[8][1]=5810431;p[9][1]=0;p[0][2]=16777215;
p[1][2]=14474460;p[2][2]=14474460;p[3][2]=14474460;p[4][2]=14474460;p[5][2]=14474460;p[6][2]=14474460;
p[7][2]=5810431;p[8][2]=0;p[9][2]=0;p[0][3]=16777215;p[1][3]=14474460;p[2][3]=14474460;
p[3][3]=14474460;p[4][3]=14474460;p[5][3]=14474460;p[6][3]=5810431;p[7][3]=0;p[8][3]=0;
p[9][3]=0;p[0][4]=16777215;p[1][4]=14474460;p[2][4]=14474460;p[3][4]=14474460;p[4][4]=14474460;
p[5][4]=5810431;p[6][4]=0;p[7][4]=0;p[8][4]=14474460;p[9][4]=0;p[0][5]=16777215;
p[1][5]=0;p[2][5]=0;p[3][5]=14474460;p[4][5]=5810431;p[5][5]=0;p[6][5]=0;
p[7][5]=14474460;p[8][5]=14474460;p[9][5]=0;p[0][6]=16777215;p[1][6]=5810431;p[2][6]=0;
p[3][6]=0;p[4][6]=5810431;p[5][6]=0;p[6][6]=14474460;p[7][6]=14474460;p[8][6]=14474460;
p[9][6]=0;p[0][7]=16777215;p[1][7]=14474460;p[2][7]=5810431;p[3][7]=0;p[4][7]=0;
p[5][7]=0;p[6][7]=14474460;p[7][7]=14474460;p[8][7]=14474460;p[9][7]=0;p[0][8]=16777215;
p[1][8]=14474460;p[2][8]=14474460;p[3][8]=5810431;p[4][8]=0;p[5][8]=14474460;p[6][8]=14474460;
p[7][8]=14474460;p[8][8]=14474460;p[9][8]=0;p[0][9]=16777215;p[1][9]=0;p[2][9]=0;
p[3][9]=0;p[4][9]=0;p[5][9]=0;p[6][9]=0;p[7][9]=0;p[8][9]=0;
p[9][9]=0;

Structure->Pic[10]=SDL_CreateRGBSurface(SDL_HWSURFACE,10,10,32,0,0,0,0);

SDL_LockSurface(Structure->Pic[10]);
for (y=0;y<10;y++){
for (x=0;x<10;x++){
putpixel(Structure->Pic[10], x, y,(p[x][y]));
}}
SDL_UnlockSurface(Structure->Pic[10]);
x=0;y=0;
for (y=0;y<17;y++){
for (x=0;x<17;x++){
p[x][y]=0;
}}
x=0;y=0;
p[0][0]=16711680;
p[1][0]=16711680;p[2][0]=16711680;p[3][0]=0;p[4][0]=0;p[5][0]=0;p[6][0]=0;
p[7][0]=16711680;p[8][0]=16711680;p[9][0]=16711680;p[0][1]=16711680;p[1][1]=16711680;p[2][1]=0;
p[3][1]=14474460;p[4][1]=14474460;p[5][1]=14474460;p[6][1]=14474460;p[7][1]=16777215;p[8][1]=16711680;
p[9][1]=16711680;p[0][2]=16711680;p[1][2]=0;p[2][2]=14474460;p[3][2]=14474460;p[4][2]=14474460;
p[5][2]=14474460;p[6][2]=14474460;p[7][2]=14474460;p[8][2]=16777215;p[9][2]=16711680;p[0][3]=0;
p[1][3]=14474460;p[2][3]=14474460;p[3][3]=14474460;p[4][3]=14474460;p[5][3]=14474460;p[6][3]=14474460;
p[7][3]=14474460;p[8][3]=14474460;p[9][3]=16777215;p[0][4]=0;p[1][4]=14474460;p[2][4]=14474460;
p[3][4]=14474460;p[4][4]=14474460;p[5][4]=14474460;p[6][4]=14474460;p[7][4]=14474460;p[8][4]=14474460;
p[9][4]=16777215;p[0][5]=0;p[1][5]=14474460;p[2][5]=14474460;p[3][5]=14474460;p[4][5]=14474460;
p[5][5]=14474460;p[6][5]=14474460;p[7][5]=14474460;p[8][5]=14474460;p[9][5]=16777215;p[0][6]=0;
p[1][6]=14474460;p[2][6]=14474460;p[3][6]=14474460;p[4][6]=14474460;p[5][6]=14474460;p[6][6]=14474460;
p[7][6]=14474460;p[8][6]=14474460;p[9][6]=16777215;p[0][7]=16711680;p[1][7]=0;p[2][7]=14474460;
p[3][7]=14474460;p[4][7]=14474460;p[5][7]=14474460;p[6][7]=14474460;p[7][7]=14474460;p[8][7]=16777215;
p[9][7]=16711680;p[0][8]=16711680;p[1][8]=16711680;p[2][8]=0;p[3][8]=14474460;p[4][8]=14474460;
p[5][8]=14474460;p[6][8]=14474460;p[7][8]=16777215;p[8][8]=16711680;p[9][8]=16711680;p[0][9]=16711680;
p[1][9]=16711680;p[2][9]=16711680;p[3][9]=16777215;p[4][9]=16777215;p[5][9]=16777215;p[6][9]=16777215;
p[7][9]=16711680;p[8][9]=16711680;p[9][9]=16711680;
Structure->Pic[11]=SDL_CreateRGBSurface(SDL_HWSURFACE,10,10,32,0,0,0,0);
SDL_LockSurface(Structure->Pic[11]);
for (y=0;y<10;y++){
for (x=0;x<10;x++){
putpixel(Structure->Pic[11], x, y,(p[x][y]));
}}
SDL_UnlockSurface(Structure->Pic[11]);
x=0;y=0;
for (y=0;y<17;y++){
for (x=0;x<17;x++){
p[x][y]=0;
}}
x=0;y=0;
p[0][0]=16711680;p[1][0]=16711680;p[2][0]=16711680;p[3][0]=16711680;p[4][0]=16711680;
p[5][0]=16711680;p[6][0]=16711680;p[7][0]=16711680;p[8][0]=16711680;p[9][0]=16711680;p[0][1]=16711680;
p[1][1]=16711680;p[2][1]=16711680;p[3][1]=16777215;p[4][1]=16777215;p[5][1]=16777215;p[6][1]=16777215;
p[7][1]=16711680;p[8][1]=16711680;p[9][1]=16711680;p[0][2]=16711680;p[1][2]=16711680;p[2][2]=16777215;
p[3][2]=10274502;p[4][2]=11262686;p[5][2]=8498142;p[6][2]=1383370;p[7][2]=16777215;p[8][2]=16711680;
p[9][2]=16711680;p[0][3]=16711680;p[1][3]=16777215;p[2][3]=9220038;p[3][3]=15398650;p[4][3]=14410751;
p[5][3]=3160059;p[6][3]=197602;p[7][3]=197569;p[8][3]=16777215;p[9][3]=16711680;p[0][4]=16711680;
p[1][4]=16777215;p[2][4]=10339550;p[3][4]=15726335;p[4][4]=13092859;p[5][4]=1776587;p[6][4]=76;
p[7][4]=153;p[8][4]=16777215;p[9][4]=16711680;p[0][5]=16711680;p[1][5]=16777215;p[2][5]=10076382;
p[3][5]=12633851;p[4][5]=3355595;p[5][5]=197427;p[6][5]=27;p[7][5]=144;p[8][5]=16777215;
p[9][5]=16711680;p[0][6]=16711680;p[1][6]=16777215;p[2][6]=7641030;p[3][6]=3753186;p[4][6]=395084;
p[5][6]=27;p[6][6]=41;p[7][6]=197508;p[8][6]=16777215;p[9][6]=16711680;p[0][7]=16711680;
p[1][7]=16711680;p[2][7]=16777215;p[3][7]=6323901;p[4][7]=988313;p[5][7]=144;p[6][7]=197508;
p[7][7]=16777215;p[8][7]=16711680;p[9][7]=16711680;p[0][8]=16711680;p[1][8]=16711680;p[2][8]=16711680;
p[3][8]=16777215;p[4][8]=16777215;p[5][8]=16777215;p[6][8]=16777215;p[7][8]=16711680;p[8][8]=16711680;
p[9][8]=16711680;p[0][9]=16711680;p[1][9]=16711680;p[2][9]=16711680;p[3][9]=16711680;p[4][9]=16711680;
p[5][9]=16711680;p[6][9]=16711680;p[7][9]=16711680;p[8][9]=16711680;p[9][9]=16711680;
Structure->Pic[12]=SDL_CreateRGBSurface(SDL_HWSURFACE,10,10,32,0,0,0,0);
SDL_LockSurface(Structure->Pic[12]);
for (y=0;y<10;y++){
for (x=0;x<10;x++){
putpixel(Structure->Pic[12], x, y,(p[x][y]));
}}
SDL_UnlockSurface(Structure->Pic[12]);
for (t=0;t<13;t++){SDL_SetColorKey(Structure->Pic[t], SDL_SRCCOLORKEY, SDL_MapRGB(Structure->Pic[t]->format, 255, 0,0 ) );
}
SDL_SetColorKey(Structure->Pic[3], SDL_SRCCOLORKEY, SDL_MapRGB(Structure->Pic[3]->format, 255, 255,255 ) );
SDL_SetColorKey(Structure->Pic[5], SDL_SRCCOLORKEY, SDL_MapRGB(Structure->Pic[5]->format, 255, 255,255 ) );
SDL_SetColorKey(Structure->Pic[9], SDL_SRCCOLORKEY, SDL_MapRGB(Structure->Pic[9]->format, 255, 0,0 ) );
SDL_SetColorKey(Structure->Pic[10], SDL_SRCCOLORKEY, SDL_MapRGB(Structure->Pic[10]->format, 255, 0,0 ) );
SDL_SetColorKey(Structure->Pic[11], SDL_SRCCOLORKEY, SDL_MapRGB(Structure->Pic[11]->format, 255, 0,0 ) );
SDL_SetColorKey(Structure->Pic[12], SDL_SRCCOLORKEY, SDL_MapRGB(Structure->Pic[12]->format, 255, 0,0 ) );
}


int WidjetTrackBar(int wx,int wy,int Width,int start,int end,int *TrackBarInOutValue,Widjet *Structure){
SDL_Rect positionfond,position;
positionfond.x=Position_Sur_La_Surface_A_Ecrire;
positionfond.y=wy;
float posTrack=0;
if (start<end){
if (*TrackBarInOutValue>=end) {*TrackBarInOutValue=end;}
if (*TrackBarInOutValue<=start) {*TrackBarInOutValue=start;}
}else{
if (*TrackBarInOutValue<=end) {*TrackBarInOutValue=end;}
if (*TrackBarInOutValue>=start) {*TrackBarInOutValue=start;}
}
float realvalue=*TrackBarInOutValue-start;

//tracer du fond
positionfond.x=Position_Sur_La_Surface_A_Ecrire-1;
SDL_BlitSurface(Structure->Pic[3],0,Structure->render,&positionfond);
positionfond.x=Position_Sur_La_Surface_A_Ecrire+Largeur_TrackBar-4;
SDL_BlitSurface(Structure->Pic[3],0,Structure->render,&positionfond);
int t=0;
for (t=1;t<Largeur_TrackBar-1;t++){
positionfond.x=Position_Sur_La_Surface_A_Ecrire+t;
SDL_BlitSurface(Structure->Pic[4],0,Structure->render,&positionfond);
}
position.y=wy+2;
position.x=round( Position_Sur_La_Surface_A_Ecrire+(((realvalue)*(Largeur_TrackBar-Largeur_Curseur))/(end-start)));
//fin du tracer du fond

//capture le track
if (((Structure->Event.mousex>Position_Sur_La_Surface_A_Ecrire)&&(Structure->Event.mousex<(Position_Sur_La_Surface_A_Ecrire+Largeur_TrackBar))&&(Structure->Event.mousey>wy)&&(Structure->Event.mousey<(wy+12)))&&(Structure->Event.mousebuttons[SDL_BUTTON_LEFT]==1) ) {
Structure->Event.mousebuttons[SDL_BUTTON_LEFT]=4;
Structure->ZoneCheckx=Position_Sur_La_Surface_A_Ecrire;
Structure->ZoneChecky=wy;
}
if ((Structure->ZoneCheckx==Position_Sur_La_Surface_A_Ecrire)&&(Structure->ZoneChecky==wy)&&(Structure->Event.mousebuttons[SDL_BUTTON_LEFT]==4) ) {
posTrack=(Structure->Event.mousex)-Position_Sur_La_Surface_A_Ecrire;
if (posTrack<Offset_Curseur) {posTrack=Offset_Curseur;}
if (posTrack>Largeur_TrackBar-Offset_Curseur) {posTrack=Largeur_TrackBar-Offset_Curseur;}
position.x=Position_Sur_La_Surface_A_Ecrire+(posTrack-Offset_Curseur);
realvalue=Position_Sur_La_Surface_A_Ecrire+(posTrack-Offset_Curseur);
*TrackBarInOutValue=round((((posTrack-Offset_Curseur)*(end-start))/(Largeur_TrackBar-Largeur_Curseur))+start);}
//fin capture du track

SDL_BlitSurface(Structure->Pic[5],0,Structure->render,&position);
return *TrackBarInOutValue;
}

int WidjetButton(int wx,int wy,int Width,int Height,char Text[255],Widjet *Structure){

SDL_Rect fillrect;
int t=0,y=0;
float center=0,centerv=0;
while (t!=1){
if (Text[y]!='\0'){ y=y+1;}else{t=1;}
}
center=((Width-((y)*(Structure->FontPic[0]->w)))/2);
centerv=((Height-(Structure->FontPic[0]->h))/2);
if ((Structure->Event.mousex<wx+1)||(Structure->Event.mousex>(wx+(Width-1)))||(Structure->Event.mousey<wy+1)||(Structure->Event.mousey>(wy+(Height-1)))) {
fillrect.x=wx;
fillrect.y=wy;
fillrect.w=Width;
fillrect.h=Height;	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorLumiere),WidjetGreen(Structure->ColorLumiere),WidjetBlue(Structure->ColorLumiere)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-bordurebutton;
fillrect.h=Height-bordurebutton;	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorOmbre),WidjetGreen(Structure->ColorOmbre),WidjetBlue(Structure->ColorOmbre)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton*2);
fillrect.h=Height-(bordurebutton*2);	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorFond),WidjetGreen(Structure->ColorFond),WidjetBlue(Structure->ColorFond)));
WidjetText(wx+center,wy+centerv,&Text[0],Structure);
}else{
if (Structure->Event.mousebuttons[SDL_BUTTON_LEFT]==1){
fillrect.x=wx;
fillrect.y=wy;
fillrect.w=Width;
fillrect.h=Height;	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorOmbre),WidjetGreen(Structure->ColorOmbre),WidjetBlue(Structure->ColorOmbre)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton);
fillrect.h=Height-(bordurebutton);	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorLumiere),WidjetGreen(Structure->ColorLumiere),WidjetBlue(Structure->ColorLumiere)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton*2);
fillrect.h=Height-(bordurebutton*2);	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorFond),WidjetGreen(Structure->ColorFond),WidjetBlue(Structure->ColorFond)));
WidjetText(wx+center,wy+centerv,&Text[0],Structure);
Structure->Event.mousebuttons[SDL_BUTTON_LEFT]=3;
Structure->ZoneCheckx=wx;
Structure->ZoneChecky=wy;
return 1;
}else{
if (Structure->Event.mousebuttons[SDL_BUTTON_LEFT]!=3){
fillrect.x=wx;
fillrect.y=wy;
fillrect.w=Width;
fillrect.h=Height;	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorLumiere),WidjetGreen(Structure->ColorLumiere),WidjetBlue(Structure->ColorLumiere)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton);
fillrect.h=Height-(bordurebutton);	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorOmbre),WidjetGreen(Structure->ColorOmbre),WidjetBlue(Structure->ColorOmbre)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton*2);
fillrect.h=Height-(bordurebutton*2);	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorSurvole),WidjetGreen(Structure->ColorSurvole),WidjetBlue(Structure->ColorSurvole)));
WidjetText(wx+center,wy+centerv,&Text[0],Structure);
return 0;
}else{
fillrect.x=wx;
fillrect.y=wy;
fillrect.w=Width;
fillrect.h=Height;	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorOmbre),WidjetGreen(Structure->ColorOmbre),WidjetBlue(Structure->ColorOmbre)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton);
fillrect.h=Height-(bordurebutton);	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorLumiere),WidjetGreen(Structure->ColorLumiere),WidjetBlue(Structure->ColorLumiere)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton*2);
fillrect.h=Height-(bordurebutton*2);	
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorClic),WidjetGreen(Structure->ColorClic),WidjetBlue(Structure->ColorClic)));
WidjetText(wx+center,wy+centerv,&Text[0],Structure);
return 0;
}}}
return 0;
}

void WidjetZoomSurface(int Zoom,SDL_Surface **Surface){
SDL_Surface *temp=NULL;
int xx=0,yy=0;
double xs=0,ys=0;
int x=(Surface[0]->w);
int y=(Surface[0]->h);
double x2=(x+Zoom);
double y2=trunc((y*(x+Zoom))/x);
temp=SDL_CreateRGBSurface(SDL_HWSURFACE,x2,y2,32,0,0,0,0);
xs=(x/x2);
ys=(y/y2);
SDL_LockSurface(temp);
for (yy=0;yy<y2;yy++){
for (xx=0;xx<x2;xx++){
putpixel(temp,xx,yy,getpixel(*Surface,trunc(xs*xx),trunc(ys*yy)));
}}
SDL_UnlockSurface(temp);
SDL_FreeSurface(*Surface);
*Surface=SDL_CreateRGBSurface(SDL_HWSURFACE,x2,y2,32,0,0,0,0);
SDL_BlitSurface(temp,0,*Surface,0);
SDL_SetColorKey( *Surface, SDL_SRCCOLORKEY, SDL_MapRGB( Surface[0]->format, 0, 0,0 ) );
SDL_FreeSurface(temp);
}


void WidjetBlitAndStretch(SDL_Surface **INSurface,Uint32 ColorAlpha,int wx,int wy,int Width,int Height,SDL_Surface **Render){
int xx=0,yy=0;
Uint32 color=0;
double xs=0,ys=0;
int x=(INSurface[0]->w);
int y=(INSurface[0]->h);
double y2=Height;
double x2=Width;
xs=(x/x2);
ys=(y/y2);
SDL_LockSurface(*Render);
for (yy=0;yy<y2;yy++){
for (xx=0;xx<x2;xx++){
color=getpixel(*INSurface,trunc(xs*xx),trunc(ys*yy));
if (ColorAlpha!=color) {putpixel(*Render,xx+wx,yy+wy,color);}
}}
SDL_UnlockSurface(*Render);
}


void WidjetBlitLine(int wx1,int wy1,Uint32 Color,int wx2,int wy2,SDL_Surface **render){
if (wx1>(render[0]->w-1)) {wx1=render[0]->w-1;}
if (wx2>(render[0]->w-1)) {wx2=render[0]->w-1;}
if (wy1>(render[0]->h-1)) {wy1=render[0]->h-1;}
if (wy2>(render[0]->h-1)) {wy2=render[0]->h-1;}
if (wx1<0) {wx1=0;}
if (wx2<0) {wx2=0;}
if (wy1<0) {wy1=0;}
if (wy2<0) {wy2=0;}
double count=0;
int comp1=0,comp2=0;
int i=0;
double fwx1=wx1,fwx2=wx2,fwy1=wy1,fwy2=wy2;
double coex=0;
double coey=0;
double x=wx1,y=wy1;
if ((wx1-wx2)<1) {comp1=wx2-wx1;}else{comp1=wx1-wx2;}
if ((wy1-wy2)<1) {comp2=wy2-wy1;}else{comp2=wy1-wy2;}
if (comp1>comp2) {count=comp1;}else{count=comp2;}
if ((fwx1-fwx2)>0) {coex=(fwx1-fwx2)/count;}else{coex=(fwx2-fwx1)/count;}
if ((fwy1-fwy2)>0) {coey=(fwy1-fwy2)/count;}else{coey=(fwy2-fwy1)/count;}
SDL_LockSurface(*render);
for (i=0;i<count;i++){
putpixel(*render,(x),(y),Color);
if (wx1<wx2) {x=x+coex;}else{x=x-coex;}
if (wy1<wy2) {y=y+coey;}else{y=y-coey;}
}
SDL_UnlockSurface(*render);
}


void WidjetProgressBar(int wx,int wy,int Width,int Height,int Min,int Max,int Value,Widjet *Structure){
SDL_Rect fillrect;
if (Value>Max) {Value=Max;}
if (Value<Min) {Value=Min;}
if (Height<5) {Height=5;}
if (Width<10) {Width=10;}
float valreal=0,rWidth=Width,rHeight=Height,rMax=Max,rMin=Min;
fillrect.x=wx;
fillrect.y=wy;
fillrect.w=Width;
fillrect.h=Height;
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorOmbre),WidjetGreen(Structure->ColorOmbre),WidjetBlue(Structure->ColorOmbre)));
fillrect.x=wx+bordureedit;
fillrect.y=wy+bordureedit;
fillrect.w=Width-bordureedit;
fillrect.h=Height-bordureedit;
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorLumiere),WidjetGreen(Structure->ColorLumiere),WidjetBlue(Structure->ColorLumiere)));
fillrect.x=wx+bordureedit;
fillrect.y=wy+bordureedit;
fillrect.w=Width-(bordureedit*2);
fillrect.h=Height-(bordureedit*2);
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorClic),WidjetGreen(Structure->ColorClic),WidjetBlue(Structure->ColorClic)));
if (Width>Height) {
fillrect.x=wx+bordureedit;
fillrect.y=wy+bordureedit;
valreal=((Value-rMin)*((rWidth-(bordureedit*2))/(rMax-rMin)));
fillrect.w=valreal;
fillrect.h=Height-(bordureedit*2);
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorProgress),WidjetGreen(Structure->ColorProgress),WidjetBlue(Structure->ColorProgress)));}else{
valreal=((Value-rMin)*((rHeight-((bordureedit*2)))/(rMax-rMin)));
fillrect.x=(wx+bordureedit);
fillrect.y=(wy-bordureedit)+(Height-trunc(valreal));
fillrect.w=Width-(bordureedit*2);
fillrect.h=valreal;
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorProgress),WidjetGreen(Structure->ColorProgress),WidjetBlue(Structure->ColorProgress)));
}
}

void WidjetFree(Widjet *Structure){
int t=0;
for (t=0;t<13;t++) {SDL_FreeSurface(Structure->Pic[t]);}
for (t=0;t<70;t++) {SDL_FreeSurface(Structure->FontPic[t]);}
SDL_FreeSurface(Structure->render);
}

int WidjetButtonBMP(int wx,int wy,int Width,int Height,char Text[255],SDL_Surface **ImageMap,Widjet *Structure){
SDL_Rect fillrect;
int t=0,y=0;
float center=0,centerv=0;
while (t!=1){
if (Text[y]!='\0'){ y=y+1;}else{t=1;}
}
center=((Width-((y)*(Structure->FontPic[0]->w)))/2);
centerv=((Height-(Structure->FontPic[0]->h))/2);
if ((Structure->Event.mousex<wx+1)||(Structure->Event.mousex>(wx+(Width-1)))||(Structure->Event.mousey<wy+1)||(Structure->Event.mousey>(wy+(Height-1)))) {
fillrect.x=wx;
fillrect.y=wy;
fillrect.w=Width;
fillrect.h=Height;
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorLumiere),WidjetGreen(Structure->ColorLumiere),WidjetBlue(Structure->ColorLumiere)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-bordurebutton;
fillrect.h=Height-bordurebutton;
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorOmbre),WidjetGreen(Structure->ColorOmbre),WidjetBlue(Structure->ColorOmbre)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton*2);
fillrect.h=Height-(bordurebutton*2);
WidjetBlitAndStretch(ImageMap,DEFAULT,wx+bordurebutton,wy+bordurebutton,Width-(bordurebutton*2),Height-(bordurebutton*2),&Structure->render);
WidjetText(wx+center,wy+centerv,&Text[0],Structure);
}else{
if (Structure->Event.mousebuttons[SDL_BUTTON_LEFT]==1){
fillrect.x=wx;
fillrect.y=wy;
fillrect.w=Width;
fillrect.h=Height;
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorOmbre),WidjetGreen(Structure->ColorOmbre),WidjetBlue(Structure->ColorOmbre)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton);
fillrect.h=Height-(bordurebutton);
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorLumiere),WidjetGreen(Structure->ColorLumiere),WidjetBlue(Structure->ColorLumiere)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton*2);
fillrect.h=Height-(bordurebutton*2);
WidjetBlitAndStretch(ImageMap,DEFAULT,wx+bordurebutton,wy+bordurebutton,Width-(bordurebutton*2),Height-(bordurebutton*2),&Structure->render);
WidjetText(wx+center,wy+centerv,&Text[0],Structure);
Structure->Event.mousebuttons[SDL_BUTTON_LEFT]=3;
Structure->ZoneCheckx=wx;
Structure->ZoneChecky=wy;
return 1;
}else{
if (Structure->Event.mousebuttons[SDL_BUTTON_LEFT]!=3){
fillrect.x=wx;
fillrect.y=wy;
fillrect.w=Width;
fillrect.h=Height;
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorLumiere),WidjetGreen(Structure->ColorLumiere),WidjetBlue(Structure->ColorLumiere)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton);
fillrect.h=Height-(bordurebutton);
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorOmbre),WidjetGreen(Structure->ColorOmbre),WidjetBlue(Structure->ColorOmbre)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton*2);
fillrect.h=Height-(bordurebutton*2);
WidjetBlitAndStretch(ImageMap,DEFAULT,wx+bordurebutton,wy+bordurebutton,Width-(bordurebutton*2),Height-(bordurebutton*2),&Structure->render);

//dessin survole
 WidjetBlitLine(wx+(Width/24)+(bordurebutton*1),wy+(Height/24)+(bordurebutton*1),1,wx+(Width-(Width/24))-(bordurebutton*1.5),wy+(Height/24)+(bordurebutton*1),&Structure->render);
WidjetBlitLine(wx+(Width/24)+(bordurebutton*1),wy+(Height/24)+(bordurebutton*1),1,wx+(Width/24)+(bordurebutton*1),wy+(Height-(Height/24))-(bordurebutton*1.5),&Structure->render);
 WidjetBlitLine(wx+(Width-(Width/24))-(bordurebutton*1.5),wy+(Height-(Height/24))-(bordurebutton*1.5),1,wx+(Width/24)+(bordurebutton*1),wy+(Height-(Height/24))-(bordurebutton*1.5),&Structure->render);
WidjetBlitLine(wx+(Width-(Width/24))-(bordurebutton*1.5),wy+(Height-(Height/24))-(bordurebutton*1.5),1,wx+(Width-(Width/24))-(bordurebutton*1.5),wy+(Height/24)+(bordurebutton*1),&Structure->render);
//fin dessin survole

WidjetText(wx+center,wy+centerv,&Text[0],Structure);
return 0;
}else{
fillrect.x=wx;
fillrect.y=wy;
fillrect.w=Width;
fillrect.h=Height;
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorOmbre),WidjetGreen(Structure->ColorOmbre),WidjetBlue(Structure->ColorOmbre)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton);
fillrect.h=Height-(bordurebutton);
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorLumiere),WidjetGreen(Structure->ColorLumiere),WidjetBlue(Structure->ColorLumiere)));
fillrect.x=wx+bordurebutton;
fillrect.y=wy+bordurebutton;
fillrect.w=Width-(bordurebutton*2);
fillrect.h=Height-(bordurebutton*2);
WidjetBlitAndStretch(ImageMap,DEFAULT,wx+bordurebutton,wy+bordurebutton,Width-(bordurebutton*2),Height-(bordurebutton*2),&Structure->render);
WidjetText(wx+center,wy+centerv,&Text[0],Structure);
return 0;
}}}
return 0;
}

int WidjetZoneToutch(int wx,int wy,int Width,int Height,Widjet *Structure){
if ((Structure->Event.mousex<wx+1)||(Structure->Event.mousex>(wx+(Width-1)))||(Structure->Event.mousey<wy+1)||(Structure->Event.mousey>(wy+(Height-1)))) {
return 0;
}
WidjetBlitLine(wx,wy,Structure->ColorSurvole,wx+Width,wy,&Structure->render);
WidjetBlitLine(wx+Width,wy,Structure->ColorSurvole,wx+Width,wy+Height,&Structure->render);
WidjetBlitLine(wx+Width,wy+Height,Structure->ColorSurvole,wx,wy+Height,&Structure->render);
WidjetBlitLine(wx,wy+Height,Structure->ColorSurvole,wx,wy,&Structure->render);
WidjetBlitLine(wx+1,wy+1,Structure->ColorOmbre,wx+Width-1,wy+1,&Structure->render);
WidjetBlitLine(wx+Width-1,wy+1,Structure->ColorOmbre,wx+Width-1,wy+Height-1,&Structure->render);
WidjetBlitLine(wx+Width-1,wy+Height-1,Structure->ColorOmbre,wx+1,wy+Height-1,&Structure->render);
WidjetBlitLine(wx+1,wy+Height-1,Structure->ColorOmbre,wx+1,wy+1,&Structure->render);
return 1;
}

int WidjetFlatPanel(int wx,int wy,int Width,int Height,Widjet *Structure){
SDL_Rect fillrect;
fillrect.x=wx;
fillrect.y=wy;
fillrect.w=Width;
fillrect.h=Height;
SDL_FillRect(Structure->render,&fillrect,SDL_MapRGB(Structure->render[0].format,WidjetRed(Structure->ColorClic),WidjetGreen(Structure->ColorClic),WidjetBlue(Structure->ColorClic)));
WidjetBlitLine(wx,wy,Structure->ColorSurvole,wx+Width,wy,&Structure->render);
WidjetBlitLine(wx+Width,wy,Structure->ColorSurvole,wx+Width,wy+Height,&Structure->render);
WidjetBlitLine(wx+Width,wy+Height,Structure->ColorSurvole,wx,wy+Height,&Structure->render);
WidjetBlitLine(wx,wy+Height,Structure->ColorSurvole,wx,wy,&Structure->render);
WidjetBlitLine(wx+1,wy+1,Structure->ColorOmbre,wx+Width-1,wy+1,&Structure->render);
WidjetBlitLine(wx+Width-1,wy+1,Structure->ColorOmbre,wx+Width-1,wy+Height-1,&Structure->render);
WidjetBlitLine(wx+Width-1,wy+Height-1,Structure->ColorOmbre,wx+1,wy+Height-1,&Structure->render);
WidjetBlitLine(wx+1,wy+Height-1,Structure->ColorOmbre,wx+1,wy+1,&Structure->render);
if ((Structure->Event.mousex<wx+1)||(Structure->Event.mousex>(wx+(Width-1)))||(Structure->Event.mousey<wy+1)||(Structure->Event.mousey>(wy+(Height-1)))) {
return 0;
}
return 1;
}

void WidjetColorSurface(Uint32 Color,SDL_Surface **Surface){
if (Color==DEFAULT) {Color=15592941;}
SDL_Rect fillrect;
fillrect.x=0;
fillrect.y=0;
fillrect.w=Surface[0]->w;
fillrect.h=Surface[0]->h;
SDL_FillRect(Surface[0],&fillrect,SDL_MapRGB(Surface[0]->format,WidjetRed(Color),WidjetGreen(Color),WidjetBlue(Color)));
}


